﻿using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Linq;
using System.Text;
using System.Windows.Forms;

namespace LINQtoTXT1
{
    public partial class Form1 : Form
    {
        public Form1()
        {
            InitializeComponent();
        }

        private void button1_Click(object sender, EventArgs e)
        {
            string nazwaPliku = @"..\..\ListaOsob.txt";
            PlikTekstowyListaOsob pt = new PlikTekstowyListaOsob(nazwaPliku);

            string s = "Pełna lista osób:\n";
            foreach (Osoba osoba in pt.listaOsob)
                s += osoba.Imię + " " + osoba.Nazwisko + " (" + osoba.Wiek + ")\n";
            MessageBox.Show(s);

            s = "Lista osób pełnoletnich:\n";
            var listaOsobPelnoletnich = from Osoba osoba in pt.listaOsob
                                        where osoba.Wiek >= 18
                                        orderby osoba.Wiek
                                        select osoba;
            foreach (Osoba osoba in listaOsobPelnoletnich) s += osoba.Imię + " " + osoba.Nazwisko + " (" + osoba.Wiek + ")\n";
            MessageBox.Show(s);
        }
    }

    class Osoba
    {
        public int Id;
        public string Imię, Nazwisko;
        public int NumerTelefonu;
        public int Wiek;

        public static Osoba Parse(string s)
        {
            Osoba osoba = new Osoba();

            //domyślne
            osoba.Id = 0;
            osoba.Imię = "";
            osoba.Nazwisko = "";
            osoba.NumerTelefonu = 0;
            osoba.Wiek = 0;

            //odczytywane z łańcucha
            const int ileElementów = 5;
            string[] elementyStr = new string[ileElementów];
            int startIndex = 0;
            for (int i = 0; i < ileElementów; ++i)
            {
                int pozycjaTabulatora = s.IndexOf('\t', startIndex);
                int dlugosc =
                   ((pozycjaTabulatora > 0) ? pozycjaTabulatora : s.Length) - startIndex;
                elementyStr[i] = s.Substring(startIndex, dlugosc);
                startIndex = pozycjaTabulatora + 1;
            }


            osoba.Id = int.Parse(elementyStr[0]);
            osoba.Imię = elementyStr[1];
            osoba.Nazwisko = elementyStr[2];
            osoba.NumerTelefonu = int.Parse(elementyStr[3]);
            osoba.Wiek = int.Parse(elementyStr[4]);

            return osoba;
        }

        public static bool TryParse(string s, out Osoba result)
        {
            try
            {
                result = Parse(s);
                return true;
            }
            catch
            {
                result = null;
                return false;
            }
        }
    }

    class PlikTekstowy
    {
        public static string[] Czytaj(string nazwaPliku, char znakKomentarza)
        {
            List<string> tekst = new List<string>();
            try
            {
                using (System.IO.StreamReader sr = new System.IO.StreamReader(nazwaPliku))
                {
                    string wiersz;
                    while ((wiersz = sr.ReadLine()) != null)
                        if (wiersz[0] != znakKomentarza) tekst.Add(wiersz);
                }
                return tekst.ToArray();
            }
            catch (Exception e)
            {
                MessageBox.Show("Błąd odczytu pliku " + nazwaPliku + "\nOpis wyjątku: " + e.Message,
                   "Błąd przy wczytywaniu pliku", MessageBoxButtons.OK, MessageBoxIcon.Error);

                return null;
            }
        }

        public static void Zapisz(string nazwaPliku, string[] tekst)
        {
            using (System.IO.StreamWriter sw = new System.IO.StreamWriter(nazwaPliku))
            {
                foreach (string wiersz in tekst)
                    sw.WriteLine(wiersz);
            }
        }
    }

    class PlikTekstowyListaOsob : PlikTekstowy
    {
        public List<Osoba> listaOsob = new List<Osoba>();

        public PlikTekstowyListaOsob(string nazwaPliku)
        {
            string[] zawartośćPliku = Czytaj(nazwaPliku, '#');
            foreach (string wiersz in zawartośćPliku)
                listaOsob.Add(Osoba.Parse(wiersz));
        }
    }
}
